/*
 * Copyright (c) 2004, 2023, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.internal.agent;

import java.io.File;
import java.io.IOException;

/*
 * Solaris/Linux implementation of jdk.internal.agent.FileSystem
 */
public class FileSystemImpl extends FileSystem {

    public boolean supportsFileSecurity(File f) throws IOException {
        return true;
    }

    public boolean isAccessUserOnly(File f) throws IOException {
        String path = f.getPath();
        if (path.indexOf(0) >= 0) {
            throw new IOException("illegal filename");
        }
        return isAccessUserOnly0(f.getPath());
    }

    // Native methods

    static native boolean isAccessUserOnly0(String path) throws IOException;

    // Initialization

    static {
        java.security.AccessController.doPrivileged(
            new java.security.PrivilegedAction<Void>() {
                public Void run() {
                    System.loadLibrary("management_agent");
                    return null;
                }
            });
    }
}
