/*
 * Decompiled with CFR 0.152.
 */
package valius.ui;

import java.awt.Rectangle;
import javax.swing.JFrame;

public class ContainableFrame
extends JFrame {
    private static final int SCREEN_EDGE_CLOSE_DISTANCE = 40;
    private boolean containedInScreen;
    private boolean expandedClientOppositeDirection;

    public void setContainedInScreen(boolean value) {
        this.containedInScreen = value;
        if (value) {
            this.setLocation(this.getX(), this.getY());
            this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.containedInScreen) {
            Rectangle bounds = this.getGraphicsConfiguration().getBounds();
            x = Math.max(x, (int)bounds.getX());
            x = Math.min(x, (int)(bounds.getX() + bounds.getWidth() - (double)this.getWidth()));
            y = Math.max(y, (int)bounds.getY());
            y = Math.min(y, (int)(bounds.getY() + bounds.getHeight() - (double)this.getHeight()));
        }
        super.setLocation(x, y);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.containedInScreen) {
            Rectangle bounds = this.getGraphicsConfiguration().getBounds();
            width = Math.min(width, width - (int)bounds.getX() + x);
            x = Math.max(x, (int)bounds.getX());
            height = Math.min(height, height - (int)bounds.getY() + y);
            y = Math.max(y, (int)bounds.getY());
            width = Math.min(width, (int)(bounds.getX() + bounds.getWidth()) - x);
            height = Math.min(height, (int)(bounds.getY() + bounds.getHeight()) - y);
        }
        super.setBounds(x, y, width, height);
    }

    public void revalidateMinimumSize() {
        this.setMinimumSize(this.getLayout().minimumLayoutSize(this));
    }

    private boolean isFullScreen() {
        return (this.getExtendedState() & 6) == 6;
    }

    private boolean isFrameCloseToLeftEdge() {
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        return Math.abs((double)this.getX() - screenBounds.getX()) <= 40.0;
    }

    private boolean isFrameCloseToRightEdge() {
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        return Math.abs((double)(this.getX() + this.getWidth()) - (screenBounds.getX() + screenBounds.getWidth())) <= 40.0;
    }
}

