/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class GlowingIcon
implements Icon,
IsHiDpiAware {
    protected Icon delegate;
    protected IconGlowTracker iconGlowTracker;
    protected Map<Float, Icon> iconMap;
    private float glowDampeningFactor = 3.0f;

    public GlowingIcon(Icon delegate, IconGlowTracker iconGlowTracker) {
        this.delegate = delegate;
        this.iconGlowTracker = iconGlowTracker;
        this.iconMap = new HashMap<Float, Icon>();
    }

    public void setDampeningFactor(float dampeningFactor) {
        this.glowDampeningFactor = dampeningFactor;
    }

    @Override
    public boolean isHiDpiAware() {
        return this.delegate instanceof IsHiDpiAware && ((IsHiDpiAware)((Object)this.delegate)).isHiDpiAware();
    }

    public Icon getDelegate() {
        return this.delegate;
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        if (this.delegate == null) {
            return;
        }
        float fadePos = this.iconGlowTracker.getIconGlowPosition();
        Icon toPaint = this.iconMap.get(Float.valueOf(fadePos));
        if (toPaint == null) {
            int width = this.getIconWidth();
            int height = this.getIconHeight();
            BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            this.delegate.paintIcon(c, graphics, 0, 0);
            int pixelWidth = image.getWidth();
            int pixelHeight = image.getHeight();
            for (int i2 = 0; i2 < pixelWidth; ++i2) {
                for (int j = 0; j < pixelHeight; ++j) {
                    int rgba = image.getRGB(i2, j);
                    int transp = rgba >>> 24 & 0xFF;
                    double coef = Math.sin(Math.PI * 2 * (double)fadePos / 2.0) / (double)this.glowDampeningFactor;
                    Color newColor = coef >= 0.0 ? SubstanceColorUtilities.getLighterColor(new Color(rgba), coef) : SubstanceColorUtilities.getDarkerColor(new Color(rgba), -coef);
                    image.setRGB(i2, j, transp << 24 | newColor.getRed() << 16 | newColor.getGreen() << 8 | newColor.getBlue());
                }
            }
            toPaint = this.isHiDpiAware() ? new SubstanceIconUIResource(image) : new ImageIcon(image);
            this.iconMap.put(Float.valueOf(fadePos), toPaint);
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.translate(x, y);
        toPaint.paintIcon(c, g2, 0, 0);
        g2d.dispose();
    }
}

