/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.SubstanceColorChooserPanel;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class ColorChooserMainPanel
extends JPanel {
    private static String lastSelectedChooserName = null;
    private JPanel chooserPanelHolder;
    private JPanel mainPanel;
    private JPanel northPanel;
    private JPanel previewPanelHolder;
    private JToolBar toolBar;
    private ButtonGroup toolBarButtonGroup;

    public ColorChooserMainPanel() {
        this.initComponents();
    }

    public void setPreviewPanel(JComponent c) {
        this.previewPanelHolder.removeAll();
        if (c != null) {
            this.previewPanelHolder.add(c);
        }
    }

    public void addColorChooserPanel(SubstanceColorChooserPanel ccp) {
        String displayName = ccp.getDisplayName();
        if (displayName.equals("Color Picker")) {
            this.northPanel.add((Component)ccp, "West");
        } else {
            JToggleButton tb = new JToggleButton();
            tb.setIcon(new TransitionAwareIcon(tb, scheme -> ccp.getHiDpiAwareIcon(18, scheme), ccp.getDisplayName()));
            tb.setToolTipText(displayName);
            tb.setFocusable(false);
            SubstanceCortex.ComponentScope.setButtonStraightSides(tb, EnumSet.allOf(SubstanceSlices.Side.class));
            JPanel centerView = new JPanel(new BorderLayout());
            centerView.add(ccp);
            this.chooserPanelHolder.add((Component)centerView, displayName);
            this.toolBarButtonGroup.add(tb);
            this.toolBar.add(tb);
            if (this.toolBar.getComponentCount() == 1 || lastSelectedChooserName != null && lastSelectedChooserName.equals(displayName)) {
                tb.setSelected(true);
                CardLayout cl = (CardLayout)this.chooserPanelHolder.getLayout();
                cl.show(this.chooserPanelHolder, displayName);
            }
            tb.addItemListener(evt -> {
                if (evt.getStateChange() == 1) {
                    CardLayout cl = (CardLayout)this.chooserPanelHolder.getLayout();
                    cl.show(this.chooserPanelHolder, displayName);
                    lastSelectedChooserName = displayName;
                }
            });
        }
    }

    public void removeAllColorChooserPanels() {
        Component[] tb = this.toolBar.getComponents();
        for (int i2 = 0; i2 < tb.length; ++i2) {
            if (!(tb[i2] instanceof AbstractButton)) continue;
            this.toolBarButtonGroup.remove((AbstractButton)tb[i2]);
        }
        this.toolBar.removeAll();
        this.chooserPanelHolder.removeAll();
        this.northPanel.removeAll();
        this.northPanel.add(this.previewPanelHolder);
    }

    private void initComponents() {
        this.toolBarButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.mainPanel = new JPanel();
        this.northPanel = new JPanel();
        this.previewPanelHolder = new JPanel();
        this.chooserPanelHolder = new JPanel();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 4, 7, 4)));
        this.northPanel.setLayout(new BorderLayout());
        this.previewPanelHolder.setLayout(new BorderLayout());
        boolean isLtr = this.northPanel.getComponentOrientation().isLeftToRight();
        this.previewPanelHolder.setBorder(new EmptyBorder(0, isLtr ? 4 : 0, 0, isLtr ? 0 : 4));
        this.northPanel.add((Component)this.previewPanelHolder, "Center");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.chooserPanelHolder.setLayout(new CardLayout());
        this.chooserPanelHolder.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        this.mainPanel.add((Component)this.chooserPanelHolder, "Center");
        this.add((Component)this.mainPanel, "Center");
    }
}

