/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.FractionBasedPainter;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class FractionBasedBorderPainter
extends FractionBasedPainter
implements SubstanceBorderPainter {
    public FractionBasedBorderPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintBorder(Graphics g2, Component c, float width, float height, Shape contour, Shape innerContour, SubstanceColorScheme borderScheme) {
        if (contour == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Color[] drawColors = new Color[this.fractions.length];
        for (int i2 = 0; i2 < this.fractions.length; ++i2) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i2];
            drawColors[i2] = colorQuery.query(borderScheme);
        }
        float strokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        boolean isSpecialButton = c != null && c.getClass().isAnnotationPresent(SubstanceInternalArrowButton.class);
        int joinKind = isSpecialButton ? 0 : 1;
        int capKind = isSpecialButton ? 2 : 0;
        graphics.setStroke(new BasicStroke(strokeWidth, capKind, joinKind));
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, drawColors, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(gradient);
        graphics.draw(contour);
        graphics.dispose();
    }

    @Override
    public boolean isPaintingInnerContour() {
        return false;
    }

    @Override
    public Color getRepresentativeColor(SubstanceColorScheme borderScheme) {
        for (int i2 = 0; i2 < this.fractions.length - 1; ++i2) {
            float fractionLow = this.fractions[i2];
            float fractionHigh = this.fractions[i2 + 1];
            if (fractionLow == 0.5f) {
                return this.colorQueries[i2].query(borderScheme);
            }
            if (fractionHigh == 0.5f) {
                return this.colorQueries[i2 + 1].query(borderScheme);
            }
            if (fractionLow < 0.5f || fractionHigh > 0.5f) continue;
            Color colorLow = this.colorQueries[i2].query(borderScheme);
            Color colorHigh = this.colorQueries[i2 + 1].query(borderScheme);
            float colorLowLikeness = (0.5f - fractionLow) / (fractionHigh - fractionLow);
            return SubstanceColorUtilities.getInterpolatedColor(colorLow, colorHigh, colorLowLikeness);
        }
        throw new IllegalStateException("Could not find representative color");
    }
}

