/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import com.google.common.base.CharMatcher;
import java.util.regex.Pattern;

public class Text {
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");

    public static String removeTags(String str) {
        return TAG_REGEXP.matcher(str).replaceAll("");
    }

    public static String standardize(String str) {
        return Text.removeTags(str).replace('\u00a0', ' ').trim().toLowerCase();
    }

    public static String toJagexName(String str) {
        return CharMatcher.ascii().retainFrom(str.replace('\u00a0', ' ')).replaceAll("[_-]+", " ").trim();
    }

    public static String sanitizeMultilineText(String str) {
        return Text.removeTags(str.replaceAll("-<br>", "-").replaceAll("<br>", " ").replaceAll("[ ]+", " "));
    }

    public static String escapeJagex(String str) {
        StringBuilder out = new StringBuilder(str.length());
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if (c == '<') {
                out.append("<lt>");
                continue;
            }
            if (c == '>') {
                out.append("<gt>");
                continue;
            }
            if (c == '\n') {
                out.append("<br>");
                continue;
            }
            if (c == '\r') continue;
            out.append(c);
        }
        return out.toString();
    }
}

