/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import lombok.NonNull;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.components.CustomScrollBarUI;
import net.runelite.client.util.ImageUtil;

public class SwingUtil {
    public static void setupDefaults() {
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(300);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        UIManager.put("Button.foreground", Color.WHITE);
        UIManager.put("MenuItem.foreground", Color.WHITE);
        UIManager.put("Panel.background", ColorScheme.DARKER_GRAY_COLOR);
        UIManager.put("ScrollBarUI", CustomScrollBarUI.class.getName());
        UIManager.put("TextField.selectionBackground", ColorScheme.BRAND_ORANGE_TRANSPARENT);
        UIManager.put("TextField.selectionForeground", Color.WHITE);
        UIManager.put("FormattedTextField.selectionBackground", ColorScheme.BRAND_ORANGE_TRANSPARENT);
        UIManager.put("FormattedTextField.selectionForeground", Color.WHITE);
        UIManager.put("TextArea.selectionBackground", ColorScheme.BRAND_ORANGE_TRANSPARENT);
        UIManager.put("TextArea.selectionForeground", Color.WHITE);
        System.setProperty("jgoodies.popupDropShadowEnabled", "false");
        System.setProperty("sun.awt.noerasebackground", "true");
    }

    public static void setTheme(@NonNull LookAndFeel laf) {
        if (laf == null) {
            throw new NullPointerException("laf is marked non-null but is null");
        }
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
    }

    public static void setFont(@NonNull Font font) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        FontUIResource f2 = new FontUIResource(font);
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f2);
        }
    }

    @Nullable
    public static TrayIcon createTrayIcon(@NonNull Image icon, @NonNull String title, final @NonNull Frame frame) {
        if (icon == null) {
            throw new NullPointerException("icon is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        if (!SystemTray.isSupported()) {
            return null;
        }
        SystemTray systemTray = SystemTray.getSystemTray();
        TrayIcon trayIcon = new TrayIcon(icon, title);
        trayIcon.setImageAutoSize(true);
        try {
            systemTray.add(trayIcon);
        }
        catch (AWTException ex) {
            ex.printStackTrace();
            return trayIcon;
        }
        trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                frame.setVisible(true);
                frame.setState(0);
            }
        });
        return trayIcon;
    }

    public static void addGracefulExitCallback(final @NonNull JFrame frame, final @NonNull Runnable callback, final @NonNull Callable<Boolean> confirmRequired) {
        if (frame == null) {
            throw new NullPointerException("frame is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (confirmRequired == null) {
            throw new NullPointerException("confirmRequired is marked non-null but is null");
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                int result = 0;
                try {
                    if (((Boolean)confirmRequired.call()).booleanValue()) {
                        result = JOptionPane.showConfirmDialog(frame, "Are you sure you want to exit?", "Exit", 2, 3);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (result == 0) {
                    callback.run();
                    System.exit(0);
                }
            }
        });
    }

    public static JButton createSwingButton(@NonNull NavigationButton navigationButton, int iconSize, @Nullable BiConsumer<NavigationButton, JButton> specialCallback) {
        if (navigationButton == null) {
            throw new NullPointerException("navigationButton is marked non-null but is null");
        }
        BufferedImage scaledImage = iconSize > 0 ? ImageUtil.resizeImage(navigationButton.getIcon(), iconSize, iconSize) : navigationButton.getIcon();
        JButton button = new JButton();
        button.setSize(scaledImage.getWidth(), scaledImage.getHeight());
        button.setToolTipText(navigationButton.getTooltip());
        button.setIcon(new ImageIcon(scaledImage));
        button.putClientProperty("substancelaf.internal.FlatLook", Boolean.TRUE);
        button.setFocusable(false);
        button.addActionListener(e -> {
            if (specialCallback != null) {
                specialCallback.accept(navigationButton, button);
            }
            if (navigationButton.getOnClick() != null) {
                navigationButton.getOnClick().run();
            }
        });
        if (navigationButton.getPopup() != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            navigationButton.getPopup().forEach((name, callback) -> {
                JMenuItem menuItem = new JMenuItem((String)name);
                menuItem.addActionListener(e -> callback.run());
                popupMenu.add(menuItem);
            });
            button.setComponentPopupMenu(popupMenu);
        }
        navigationButton.setOnSelect(button::doClick);
        return button;
    }
}

