/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.Color;

public class ColorUtil {
    private static final String OPENING_COLOR_TAG_START = "<col=";
    private static final String OPENING_COLOR_TAG_END = ">";
    private static final String CLOSING_COLOR_TAG = "</col>";

    public static String colorTag(Color color) {
        return OPENING_COLOR_TAG_START + ColorUtil.colorToHexCode(color) + OPENING_COLOR_TAG_END;
    }

    public static String prependColorTag(String str, Color color) {
        return ColorUtil.colorTag(color) + str;
    }

    public static String wrapWithColorTag(String str, Color color) {
        return ColorUtil.prependColorTag(str, color) + CLOSING_COLOR_TAG;
    }

    public static String toHexColor(Color color) {
        return "#" + ColorUtil.colorToHexCode(color);
    }

    public static Color colorLerp(Color a2, Color b2, double t) {
        double r1 = a2.getRed();
        double r2 = b2.getRed();
        double g1 = a2.getGreen();
        double g2 = b2.getGreen();
        double b1 = a2.getBlue();
        double b22 = b2.getBlue();
        return new Color((int)Math.round(r1 + t * (r2 - r1)), (int)Math.round(g1 + t * (g2 - g1)), (int)Math.round(b1 + t * (b22 - b1)));
    }

    static String colorToHexCode(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    static boolean isFullyTransparent(Color color) {
        return color.getAlpha() == 0;
    }

    static boolean isNotFullyTransparent(Color color) {
        return !ColorUtil.isFullyTransparent(color);
    }
}

