/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class ThinProgressBar
extends JPanel {
    private int maximumValue;
    private int value;
    private final JPanel topBar = new JPanel();

    public ThinProgressBar() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.GREEN.darker());
        this.topBar.setPreferredSize(new Dimension(100, 4));
        this.topBar.setBackground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        this.add((Component)this.topBar, "West");
    }

    public void update() {
        double percentage = this.getPercentage();
        int topWidth = (int)((double)this.getSize().width * (percentage / 100.0));
        this.topBar.setPreferredSize(new Dimension(topWidth, 4));
        this.topBar.repaint();
        this.revalidate();
        this.repaint();
    }

    public double getPercentage() {
        if (this.value == 0) {
            return 0.0;
        }
        return this.value * 100 / this.maximumValue;
    }

    @Override
    public void setForeground(Color color) {
        if (this.topBar != null) {
            this.topBar.setBackground(color);
        }
        this.setBackground(color.darker());
    }
}

