/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.DimmableJPanel;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;

public class ProgressBar
extends DimmableJPanel {
    private int maximumValue;
    private int value;
    private final JLabel leftLabel = new JShadowedLabel();
    private final JLabel rightLabel = new JShadowedLabel();
    private final JLabel centerLabel = new JShadowedLabel();
    private String centerLabelText = "";
    private String dimmedText = "";

    public ProgressBar() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.GREEN.darker());
        this.setForeground(Color.GREEN.brighter());
        this.setPreferredSize(new Dimension(100, 16));
        this.leftLabel.setFont(FontManager.getRunescapeSmallFont());
        this.leftLabel.setForeground(Color.WHITE);
        this.leftLabel.setBorder(new EmptyBorder(2, 5, 0, 0));
        this.rightLabel.setFont(FontManager.getRunescapeSmallFont());
        this.rightLabel.setForeground(Color.WHITE);
        this.rightLabel.setBorder(new EmptyBorder(2, 0, 0, 5));
        this.centerLabel.setFont(FontManager.getRunescapeSmallFont());
        this.centerLabel.setForeground(Color.WHITE);
        this.centerLabel.setHorizontalAlignment(0);
        this.centerLabel.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.add((Component)this.leftLabel, "West");
        this.add((Component)this.centerLabel, "Center");
        this.add((Component)this.rightLabel, "East");
    }

    @Override
    public void paint(Graphics g2) {
        double percentage = this.getPercentage();
        int topWidth = (int)((double)this.getSize().width * (percentage / 100.0));
        super.paint(g2);
        g2.setColor(this.getForeground());
        g2.fillRect(0, 0, topWidth, 16);
        super.paintComponents(g2);
    }

    @Override
    public void setDimmed(boolean dimmed) {
        super.setDimmed(dimmed);
        if (dimmed) {
            this.leftLabel.setForeground(Color.GRAY);
            this.rightLabel.setForeground(Color.GRAY);
            this.centerLabel.setText(this.dimmedText);
        } else {
            this.leftLabel.setForeground(Color.WHITE);
            this.rightLabel.setForeground(Color.WHITE);
            this.centerLabel.setText(this.centerLabelText);
        }
    }

    public void setLeftLabel(String txt) {
        this.leftLabel.setText(txt);
    }

    public void setRightLabel(String txt) {
        this.rightLabel.setText(txt);
    }

    public void setCenterLabel(String txt) {
        this.centerLabelText = txt;
        this.centerLabel.setText(this.dimmed ? this.dimmedText : txt);
    }

    public void setDimmedText(String txt) {
        this.dimmedText = txt;
        this.centerLabel.setText(this.dimmed ? txt : this.centerLabelText);
    }

    public double getPercentage() {
        if (this.value == 0) {
            return 0.0;
        }
        return this.value * 100 / this.maximumValue;
    }
}

