/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import net.runelite.client.input.KeyListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.FlatTextField;

public class IconTextField
extends JPanel {
    private final JLabel iconWrapperLabel;
    private final FlatTextField textField;
    private final JButton clearButton;

    public IconTextField() {
        this.setLayout(new BorderLayout());
        this.iconWrapperLabel = new JLabel();
        this.iconWrapperLabel.setPreferredSize(new Dimension(30, 0));
        this.iconWrapperLabel.setVerticalAlignment(0);
        this.iconWrapperLabel.setHorizontalAlignment(0);
        this.textField = new FlatTextField();
        this.textField.setBorder(null);
        JTextField innerTxt = this.textField.getTextField();
        innerTxt.removeMouseListener(innerTxt.getMouseListeners()[innerTxt.getMouseListeners().length - 1]);
        MouseAdapter hoverEffect = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (IconTextField.this.textField.isBlocked()) {
                    return;
                }
                Color hoverColor = IconTextField.this.textField.getHoverBackgroundColor();
                if (hoverColor != null) {
                    IconTextField.super.setBackground(hoverColor);
                    IconTextField.this.textField.setBackground(hoverColor, false);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                IconTextField.this.setBackground(IconTextField.this.textField.getBackgroundColor());
            }
        };
        this.textField.addMouseListener(hoverEffect);
        innerTxt.addMouseListener(hoverEffect);
        this.clearButton = new JButton("\u00c3\u2014");
        this.clearButton.setPreferredSize(new Dimension(30, 0));
        this.clearButton.setFont(FontManager.getRunescapeBoldFont());
        this.clearButton.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.clearButton.setBorder(null);
        this.clearButton.setBorderPainted(false);
        this.clearButton.setContentAreaFilled(false);
        this.clearButton.setVisible(false);
        this.clearButton.addActionListener(evt -> this.setText(null));
        this.clearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                IconTextField.this.setText(null);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                IconTextField.this.clearButton.setForeground(Color.PINK);
                IconTextField.this.textField.dispatchEvent(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                IconTextField.this.clearButton.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
                IconTextField.this.textField.dispatchEvent(mouseEvent);
            }
        });
        this.textField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> IconTextField.this.clearButton.setVisible(true));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> IconTextField.this.clearButton.setVisible(!IconTextField.this.getText().isEmpty()));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.add((Component)this.iconWrapperLabel, "West");
        this.add((Component)this.textField, "Center");
        this.add((Component)this.clearButton, "East");
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public void setIcon(Icon icon) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(icon.getFile()));
        this.iconWrapperLabel.setIcon(imageIcon);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            return;
        }
        super.setBackground(color);
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }

    public void setHoverBackgroundColor(Color hoverBackgroundColor) {
        if (hoverBackgroundColor == null) {
            return;
        }
        this.textField.setHoverBackgroundColor(hoverBackgroundColor);
    }

    @Override
    public void addKeyListener(java.awt.event.KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public void addKeyListener(final Consumer<KeyEvent> keyEventConsumer) {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                keyEventConsumer.accept(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                keyEventConsumer.accept(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                keyEventConsumer.accept(e);
            }
        });
    }

    @Override
    public void removeKeyListener(java.awt.event.KeyListener keyListener) {
        this.textField.removeKeyListener(keyListener);
    }

    public void setEditable(boolean editable) {
        this.textField.setEditable(editable);
        if (!editable) {
            super.setBackground(this.textField.getBackgroundColor());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.textField.requestFocusInWindow();
    }

    public Document getDocument() {
        return this.textField.getDocument();
    }

    public static enum Icon {
        SEARCH("search.png"),
        LOADING("loading_spinner.gif"),
        LOADING_DARKER("loading_spinner_darker.gif"),
        ERROR("error.png");

        private final String file;

        private Icon(String file) {
            this.file = file;
        }

        public String getFile() {
            return this.file;
        }
    }
}

