/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import javax.swing.text.StyleContext;

public class FontManager {
    private static final Font runescapeFont;
    private static final Font runescapeSmallFont;
    private static final Font runescapeBoldFont;

    public static Font getRunescapeFont() {
        return runescapeFont;
    }

    public static Font getRunescapeSmallFont() {
        return runescapeSmallFont;
    }

    public static Font getRunescapeBoldFont() {
        return runescapeBoldFont;
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            Font font = Font.createFont(0, FontManager.class.getResourceAsStream("runescape.ttf")).deriveFont(0, 16.0f);
            ge.registerFont(font);
            runescapeFont = StyleContext.getDefaultStyleContext().getFont(font.getName(), 0, 16);
            ge.registerFont(runescapeFont);
            Font smallFont = Font.createFont(0, FontManager.class.getResourceAsStream("runescape_small.ttf")).deriveFont(0, 16.0f);
            ge.registerFont(smallFont);
            runescapeSmallFont = StyleContext.getDefaultStyleContext().getFont(smallFont.getName(), 0, 16);
            ge.registerFont(runescapeSmallFont);
            Font boldFont = Font.createFont(0, FontManager.class.getResourceAsStream("runescape_bold.ttf")).deriveFont(0, 16.0f);
            ge.registerFont(boldFont);
            runescapeBoldFont = StyleContext.getDefaultStyleContext().getFont(boldFont.getName(), 0, 16);
            ge.registerFont(runescapeBoldFont);
        }
        catch (FontFormatException ex) {
            throw new RuntimeException("Font loaded, but format incorrect.", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Font file not found.", ex);
        }
    }
}

