/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.Image;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DrawManager {
    private final List<Runnable> everyFrame = new CopyOnWriteArrayList<Runnable>();
    private final Queue<Consumer<Image>> nextFrame = new ConcurrentLinkedQueue<Consumer<Image>>();

    public void registerEveryFrameListener(Runnable everyFrameListener) {
        if (!this.everyFrame.contains(everyFrameListener)) {
            this.everyFrame.add(everyFrameListener);
        }
    }

    public void unregisterEveryFrameListener(Runnable everyFrameListener) {
        this.everyFrame.remove(everyFrameListener);
    }

    public void requestNextFrameListener(Consumer<Image> nextFrameListener) {
        this.nextFrame.add(nextFrameListener);
    }

    public void processDrawComplete(Supplier<Image> imageSupplier) {
        for (Runnable everyFrameListener : this.everyFrame) {
            try {
                everyFrameListener.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Consumer<Image> nextFrameListener = this.nextFrame.poll();
        Image image = null;
        while (nextFrameListener != null) {
            if (image == null) {
                try {
                    image = imageSupplier.get();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (image == null) {
                this.nextFrame.clear();
                break;
            }
            try {
                nextFrameListener.accept(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            nextFrameListener = this.nextFrame.poll();
        }
    }
}

