/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JFrame;
import net.runelite.client.config.ExpandResizeType;

public class ContainableFrame
extends JFrame {
    private static final int SCREEN_EDGE_CLOSE_DISTANCE = 40;
    private ExpandResizeType expandResizeType;
    private boolean containedInScreen;
    private boolean expandedClientOppositeDirection;

    public void setContainedInScreen(boolean value) {
        this.containedInScreen = value;
        if (value) {
            this.setLocation(this.getX(), this.getY());
            this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.containedInScreen) {
            Rectangle bounds = this.getGraphicsConfiguration().getBounds();
            x = Math.max(x, (int)bounds.getX());
            x = Math.min(x, (int)(bounds.getX() + bounds.getWidth() - (double)this.getWidth()));
            y = Math.max(y, (int)bounds.getY());
            y = Math.min(y, (int)(bounds.getY() + bounds.getHeight() - (double)this.getHeight()));
        }
        super.setLocation(x, y);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.containedInScreen) {
            Rectangle bounds = this.getGraphicsConfiguration().getBounds();
            width = Math.min(width, width - (int)bounds.getX() + x);
            x = Math.max(x, (int)bounds.getX());
            height = Math.min(height, height - (int)bounds.getY() + y);
            y = Math.max(y, (int)bounds.getY());
            width = Math.min(width, (int)(bounds.getX() + bounds.getWidth()) - x);
            height = Math.min(height, (int)(bounds.getY() + bounds.getHeight()) - y);
        }
        super.setBounds(x, y, width, height);
    }

    public void expandBy(int value) {
        int currentWidth;
        int minimumWidth;
        if (this.isFullScreen()) {
            return;
        }
        int increment = value;
        boolean forcedWidthIncrease = false;
        if (this.expandResizeType == ExpandResizeType.KEEP_WINDOW_SIZE && (minimumWidth = this.getLayout().minimumLayoutSize((Container)this).width) > (currentWidth = this.getWidth())) {
            forcedWidthIncrease = true;
            increment = minimumWidth - currentWidth;
        }
        if (forcedWidthIncrease || this.expandResizeType == ExpandResizeType.KEEP_GAME_SIZE) {
            int newWindowWidth = this.getWidth() + increment;
            Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
            boolean wouldExpandThroughEdge = (double)(this.getX() + newWindowWidth) > screenBounds.getX() + screenBounds.getWidth();
            int newWindowX = this.getX();
            if (wouldExpandThroughEdge) {
                if (!this.isFrameCloseToRightEdge() || this.isFrameCloseToLeftEdge()) {
                    newWindowX = (int)(screenBounds.getX() + screenBounds.getWidth()) - this.getWidth();
                }
                newWindowX -= increment;
                this.expandedClientOppositeDirection = true;
            }
            this.setBounds(newWindowX, this.getY(), newWindowWidth, this.getHeight());
        }
        this.revalidateMinimumSize();
    }

    public void contractBy(int value) {
        if (this.isFullScreen()) {
            return;
        }
        this.revalidateMinimumSize();
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        boolean wasCloseToLeftEdge = Math.abs((double)this.getX() - screenBounds.getX()) <= 40.0;
        int newWindowX = this.getX();
        int newWindowWidth = this.getWidth() - value;
        if (this.isFrameCloseToRightEdge() && (this.expandedClientOppositeDirection || !wasCloseToLeftEdge)) {
            newWindowX += value;
        }
        if (this.expandResizeType == ExpandResizeType.KEEP_WINDOW_SIZE && newWindowWidth > this.getMinimumSize().width) {
            newWindowWidth = this.getWidth();
            newWindowX = this.getX();
        }
        this.setBounds(newWindowX, this.getY(), newWindowWidth, this.getHeight());
        this.expandedClientOppositeDirection = false;
    }

    public void revalidateMinimumSize() {
        this.setMinimumSize(this.getLayout().minimumLayoutSize(this));
    }

    private boolean isFullScreen() {
        return (this.getExtendedState() & 6) == 6;
    }

    private boolean isFrameCloseToLeftEdge() {
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        return Math.abs((double)this.getX() - screenBounds.getX()) <= 40.0;
    }

    private boolean isFrameCloseToRightEdge() {
        Rectangle screenBounds = this.getGraphicsConfiguration().getBounds();
        return Math.abs((double)(this.getX() + this.getWidth()) - (screenBounds.getX() + screenBounds.getWidth())) <= 40.0;
    }
}

