/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.ui;

import com.client.Loader;
import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NavigationButtonAdded;
import net.runelite.client.events.NavigationButtonRemoved;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.ui.ClientPanel;
import net.runelite.client.ui.ClientPluginToolbar;
import net.runelite.client.ui.ClientTitleToolbar;
import net.runelite.client.ui.ContainableFrame;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.skin.SubstanceRuneLiteLookAndFeel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePaneUtilities;

public class ClientUI {
    private static final String CONFIG_GROUP = "runelite";
    private static final String CONFIG_CLIENT_BOUNDS = "clientBounds";
    private static final String CONFIG_CLIENT_MAXIMIZED = "clientMaximized";
    private static final int CLIENT_WELL_HIDDEN_MARGIN = 160;
    private static final int CLIENT_WELL_HIDDEN_MARGIN_TOP = 10;
    public static final BufferedImage ICON = ImageUtil.getResourceStreamFromClass(ClientUI.class, "/com/client/favicon.png");
    private TrayIcon trayIcon;
    private Applet client;
    private final CardLayout cardLayout = new CardLayout();
    private final Rectangle sidebarButtonPosition = new Rectangle();
    private boolean withTitleBar;
    private BufferedImage sidebarOpenIcon;
    private BufferedImage sidebarClosedIcon;
    private ContainableFrame frame;
    private JPanel navContainer;
    private PluginPanel pluginPanel;
    private ClientPluginToolbar pluginToolbar;
    private ClientTitleToolbar titleToolbar;
    private JButton currentButton;
    private NavigationButton currentNavButton;
    private boolean sidebarOpen;
    private JPanel container;
    private NavigationButton sidebarNavigationButton;
    private JButton sidebarNavigationJButton;
    private Dimension lastClientSize;

    @Subscribe
    public void onNavigationButtonAdded(NavigationButtonAdded event) {
        SwingUtilities.invokeLater(() -> {
            NavigationButton navigationButton = event.getButton();
            PluginPanel pluginPanel = navigationButton.getPanel();
            boolean inTitle = !event.getButton().isTab() && this.withTitleBar;
            int iconSize = 16;
            if (pluginPanel != null) {
                this.navContainer.add((Component)pluginPanel.getWrappedPanel(), navigationButton.getTooltip());
            }
            JButton button = SwingUtil.createSwingButton(navigationButton, 16, (navButton, jButton) -> {
                boolean doClose;
                PluginPanel panel = navButton.getPanel();
                if (panel == null) {
                    return;
                }
                boolean bl = doClose = this.currentButton != null && this.currentButton == jButton && this.currentButton.isSelected();
                if (doClose) {
                    this.contract();
                    this.currentButton.setSelected(false);
                    this.currentNavButton.setSelected(false);
                    this.currentButton = null;
                    this.currentNavButton = null;
                } else {
                    if (this.currentButton != null) {
                        this.currentButton.setSelected(false);
                    }
                    if (this.currentNavButton != null) {
                        this.currentNavButton.setSelected(false);
                    }
                    this.currentButton = jButton;
                    this.currentNavButton = navButton;
                    this.currentButton.setSelected(true);
                    this.currentNavButton.setSelected(true);
                    this.expand((NavigationButton)navButton);
                }
            });
            if (inTitle) {
                this.titleToolbar.addComponent(event.getButton(), button);
            } else {
                this.pluginToolbar.addComponent(event.getButton(), button);
            }
        });
    }

    @Subscribe
    public void onNavigationButtonRemoved(NavigationButtonRemoved event) {
        SwingUtilities.invokeLater(() -> {
            this.pluginToolbar.removeComponent(event.getButton());
            this.titleToolbar.removeComponent(event.getButton());
            PluginPanel pluginPanel = event.getButton().getPanel();
            if (pluginPanel != null) {
                this.navContainer.remove(pluginPanel.getWrappedPanel());
            }
        });
    }

    public void open(Loader client_panel) throws Exception {
        this.client = client_panel;
        SwingUtilities.invokeAndWait(() -> {
            SwingUtil.setupDefaults();
            SwingUtil.setTheme(new SubstanceRuneLiteLookAndFeel());
            SwingUtil.setFont(FontManager.getRunescapeFont());
            this.frame = new ContainableFrame();
            this.frame.setTitle("AstralForge");
            this.frame.setIconImage(ICON);
            this.frame.getLayeredPane().setCursor(Cursor.getDefaultCursor());
            this.frame.setLocationRelativeTo(this.frame.getOwner());
            this.frame.setResizable(true);
            this.frame.setDefaultCloseOperation(3);
            this.container = new JPanel();
            this.container.setLayout(new BoxLayout(this.container, 0));
            this.container.add(new ClientPanel(client_panel));
            this.navContainer = new JPanel();
            this.navContainer.setLayout(this.cardLayout);
            this.navContainer.setMinimumSize(new Dimension(0, 0));
            this.navContainer.setMaximumSize(new Dimension(0, 0));
            this.navContainer.setPreferredSize(new Dimension(0, 0));
            this.navContainer.putClientProperty("substancelaf.internal.colorizationFactor", 1.0);
            this.container.add(this.navContainer);
            this.pluginToolbar = new ClientPluginToolbar();
            this.titleToolbar = new ClientTitleToolbar();
            this.frame.add(this.container);
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public MouseEvent mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && ClientUI.this.sidebarButtonPosition.contains(mouseEvent.getPoint())) {
                        SwingUtilities.invokeLater(() -> ClientUI.this.toggleSidebar());
                        mouseEvent.consume();
                    }
                    return mouseEvent;
                }
            };
            this.withTitleBar = true;
            this.frame.setUndecorated(this.withTitleBar);
            if (this.withTitleBar) {
                this.frame.getRootPane().setWindowDecorationStyle(1);
                final JComponent titleBar = SubstanceCoreUtilities.getTitlePaneComponent(this.frame);
                this.titleToolbar.putClientProperty("substancelaf.internal.titlePane.extraComponentKind", (Object)SubstanceTitlePaneUtilities.ExtraComponentKind.TRAILING);
                titleBar.add(this.titleToolbar);
                final LayoutManager delegate = titleBar.getLayout();
                titleBar.setLayout(new LayoutManager(){

                    @Override
                    public void addLayoutComponent(String name, Component comp) {
                        delegate.addLayoutComponent(name, comp);
                    }

                    @Override
                    public void removeLayoutComponent(Component comp) {
                        delegate.removeLayoutComponent(comp);
                    }

                    @Override
                    public Dimension preferredLayoutSize(Container parent) {
                        return delegate.preferredLayoutSize(parent);
                    }

                    @Override
                    public Dimension minimumLayoutSize(Container parent) {
                        return delegate.minimumLayoutSize(parent);
                    }

                    @Override
                    public void layoutContainer(Container parent) {
                        delegate.layoutContainer(parent);
                        int width = ((ClientUI)ClientUI.this).titleToolbar.getPreferredSize().width;
                        ClientUI.this.titleToolbar.setBounds(titleBar.getWidth() - 75 - width, 0, width, titleBar.getHeight());
                    }
                });
            }
            this.sidebarOpenIcon = ImageUtil.getResourceStreamFromClass(ClientUI.class, this.withTitleBar ? "open.png" : "open_rs.png");
            this.sidebarClosedIcon = ImageUtil.flipImage(this.sidebarOpenIcon, true, false);
            this.sidebarNavigationButton = NavigationButton.builder().priority(100).icon(this.sidebarClosedIcon).onClick(this::toggleSidebar).build();
            this.sidebarNavigationJButton = SwingUtil.createSwingButton(this.sidebarNavigationButton, 0, null);
            this.titleToolbar.addComponent(this.sidebarNavigationButton, this.sidebarNavigationJButton);
            this.toggleSidebar();
            this.frame.pack();
            this.frame.revalidateMinimumSize();
            this.trayIcon = SwingUtil.createTrayIcon(ICON, "AstralForge", this.frame);
            this.frame.setLocationRelativeTo(this.frame.getOwner());
            Rectangle clientBounds = this.frame.getBounds();
            Rectangle screenBounds = this.frame.getGraphicsConfiguration().getBounds();
            if ((double)(clientBounds.x + clientBounds.width - 160) < screenBounds.getX() || (double)(clientBounds.x + 160) > screenBounds.getX() + screenBounds.getWidth() || (double)(clientBounds.y + 10) < screenBounds.getY() || (double)(clientBounds.y + 160) > screenBounds.getY() + screenBounds.getHeight()) {
                this.frame.setLocationRelativeTo(this.frame.getOwner());
            }
            this.frame.setVisible(true);
            this.frame.toFront();
            this.requestFocus();
            this.giveClientFocus();
        });
    }

    public void paint(Graphics graphics) {
        this.frame.paint(graphics);
    }

    public int getWidth() {
        return this.frame.getWidth();
    }

    public int getHeight() {
        return this.frame.getHeight();
    }

    public boolean isFocused() {
        return this.frame.isFocused();
    }

    public void requestFocus() {
        this.frame.requestFocus();
        this.giveClientFocus();
    }

    public Point getCanvasOffset() {
        Point point = SwingUtilities.convertPoint(this.client, 0, 0, this.frame);
        return new Point(point.x, point.y);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.frame.getGraphicsConfiguration();
    }

    private void toggleSidebar() {
        boolean isSidebarOpen = this.sidebarOpen;
        boolean bl = this.sidebarOpen = !this.sidebarOpen;
        if (this.currentButton != null) {
            this.currentButton.setSelected(this.sidebarOpen);
        }
        if (this.currentNavButton != null) {
            this.currentNavButton.setSelected(this.sidebarOpen);
        }
        if (isSidebarOpen) {
            this.sidebarNavigationJButton.setIcon(new ImageIcon(this.sidebarOpenIcon));
            this.sidebarNavigationJButton.setToolTipText("Open SideBar");
            this.contract();
            this.container.remove(this.pluginToolbar);
        } else {
            this.sidebarNavigationJButton.setIcon(new ImageIcon(this.sidebarClosedIcon));
            this.sidebarNavigationJButton.setToolTipText("Close SideBar");
            this.expand(this.currentNavButton);
            this.container.add(this.pluginToolbar);
        }
        this.container.revalidate();
        this.giveClientFocus();
        if (this.sidebarOpen) {
            this.frame.expandBy(this.pluginToolbar.getWidth());
        } else {
            this.frame.contractBy(this.pluginToolbar.getWidth());
        }
    }

    private void expand(@Nullable NavigationButton button) {
        if (button == null) {
            return;
        }
        PluginPanel panel = button.getPanel();
        if (panel == null) {
            return;
        }
        if (!this.sidebarOpen) {
            this.toggleSidebar();
        }
        int width = panel.getWrappedPanel().getPreferredSize().width;
        int expandBy = this.pluginPanel != null ? this.pluginPanel.getWrappedPanel().getPreferredSize().width - width : width;
        this.pluginPanel = panel;
        this.navContainer.setMinimumSize(new Dimension(width, 0));
        this.navContainer.setMaximumSize(new Dimension(width, Integer.MAX_VALUE));
        this.navContainer.setPreferredSize(new Dimension(width, 0));
        this.navContainer.revalidate();
        this.cardLayout.show(this.navContainer, button.getTooltip());
        this.giveClientFocus();
        panel.onActivate();
        if (expandBy > 0) {
            this.frame.expandBy(expandBy);
        } else if (expandBy < 0) {
            this.frame.contractBy(expandBy);
        }
    }

    private void contract() {
        if (this.pluginPanel == null) {
            return;
        }
        this.pluginPanel.onDeactivate();
        this.navContainer.setMinimumSize(new Dimension(0, 0));
        this.navContainer.setMaximumSize(new Dimension(0, 0));
        this.navContainer.setPreferredSize(new Dimension(0, 0));
        this.navContainer.revalidate();
        this.giveClientFocus();
        this.frame.contractBy(this.pluginPanel.getWrappedPanel().getPreferredSize().width);
        this.pluginPanel = null;
    }

    private void giveClientFocus() {
        if (this.client != null) {
            this.client.requestFocusInWindow();
        }
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public ContainableFrame getFrame() {
        return this.frame;
    }
}

